<?php
/**
 * Menú lateral plegable con botón toggle
 * Incluir este archivo en todas las páginas que necesiten el menú
 */
?>
<style>
    :root {
        --menu-width: 280px;
        --menu-collapsed-width: 80px;
        --transition-speed: 0.3s;
        --primary-color: #ffa500;
        --dark-bg: #0f171e;
        --light-text: #ffffff;
    }

    /* Menú lateral */
    .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        width: var(--menu-width);
        height: 100vh;
        background: var(--dark-bg);
        border-right: 1px solid rgba(255, 255, 255, 0.1);
        z-index: 100;
        transition: all var(--transition-speed) ease;
        overflow-y: auto;
    }

    .sidebar.collapsed {
        width: var(--menu-collapsed-width);
    }

    .sidebar.collapsed .menu-text {
        display: none;
    }

    .sidebar.collapsed .logo-text {
        display: none;
    }

    .sidebar.collapsed .nav-item {
        justify-content: center;
    }

    /* Logo y cabecera */
    .logo-container {
        display: flex;
        align-items: center;
        padding: 20px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }

    .logo-img {
        width: 40px;
        height: 40px;
        margin-right: 15px;
    }

    .logo-text {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--light-text);
        transition: opacity var(--transition-speed);
    }

    /* Items del menú */
    .nav-menu {
        padding: 20px 0;
    }

    .nav-item {
        display: flex;
        align-items: center;
        padding: 12px 20px;
        color: rgba(255, 255, 255, 0.8);
        text-decoration: none;
        transition: all 0.3s ease;
    }

    .nav-item:hover, .nav-item.active {
        background: rgba(255, 255, 255, 0.1);
        color: var(--light-text);
    }

    .nav-item i {
        font-size: 1.2rem;
        margin-right: 15px;
        min-width: 24px;
    }

    .menu-text {
        font-size: 1rem;
        font-weight: 500;
        transition: opacity var(--transition-speed);
    }

    /* Botón toggle */
    .toggle-btn {
        position: absolute;
        right: -15px;
        top: 20px;
        width: 30px;
        height: 30px;
        background: var(--primary-color);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
        z-index: 101;
        border: none;
        color: #000;
    }

    .toggle-btn i {
        transition: transform var(--transition-speed);
    }

    .sidebar.collapsed .toggle-btn i {
        transform: rotate(180deg);
    }

    /* Botón móvil */
    .mobile-menu-btn {
        display: none;
        background: none;
        border: none;
        color: var(--light-text);
        font-size: 1.5rem;
        cursor: pointer;
        margin-right: 15px;
    }

    /* Responsive */
    @media (max-width: 992px) {
        .sidebar {
            transform: translateX(-100%);
            width: 280px;
        }
        
        .sidebar.show {
            transform: translateX(0);
        }
        
        .sidebar.collapsed {
            width: 280px;
            transform: translateX(-100%);
        }
        
        .sidebar.collapsed.show {
            transform: translateX(0);
        }
        
        .sidebar.collapsed .menu-text,
        .sidebar.collapsed .logo-text {
            display: block;
        }
        
        .sidebar.collapsed .nav-item {
            justify-content: flex-start;
        }
        
        .mobile-menu-btn {
            display: block;
        }
        
        .toggle-btn {
            display: none;
        }
    }
</style>

<aside class="sidebar">
    <div class="logo-container">
        <img src="logo.png" alt="Logo" class="logo-img">
        <span class="logo-text">IPTV Pro</span>
    </div>
    
    <button class="toggle-btn" onclick="toggleSidebar()">
        <i class="fas fa-chevron-left"></i>
    </button>
    
    <nav class="nav-menu">
        <a href="dashboard.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : '' ?>">
            <i class="fas fa-tachometer-alt"></i>
            <span class="menu-text">Dashboard</span>
        </a>
        <a href="live.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) == 'live.php' ? 'active' : '' ?>">
            <i class="fas fa-tv"></i>
            <span class="menu-text">TV En Vivo</span>
        </a>
        <a href="movies.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) == 'movies.php' ? 'active' : '' ?>">
            <i class="fas fa-film"></i>
            <span class="menu-text">Películas</span>
        </a>
        <a href="series.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) == 'series.php' ? 'active' : '' ?>">
            <i class="fas fa-tv"></i>
            <span class="menu-text">Series</span>
        </a>
        <a href="categories.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'active' : '' ?>">
            <i class="fas fa-list"></i>
            <span class="menu-text">Categorías</span>
        </a>
        <a href="favorites.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) == 'favorites.php' ? 'active' : '' ?>">
            <i class="fas fa-heart"></i>
            <span class="menu-text">Favoritos</span>
        </a>
        <a href="settings.php" class="nav-item <?= basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'active' : '' ?>">
            <i class="fas fa-cog"></i>
            <span class="menu-text">Ajustes</span>
        </a>
        <a href="logout.php" class="nav-item">
            <i class="fas fa-sign-out-alt"></i>
            <span class="menu-text">Cerrar Sesión</span>
        </a>
    </nav>
</aside>

<button class="mobile-menu-btn" onclick="toggleMobileMenu()">
    <i class="fas fa-bars"></i>
</button>