/**
 * Funcionalidad del menú lateral plegable
 * Incluir este archivo en todas las páginas que usen el menú
 */

let sidebarCollapsed = false;
let mobileMenuOpen = false;

// Toggle del menú lateral (versión desktop)
function toggleSidebar() {
    const sidebar = document.querySelector('.sidebar');
    sidebarCollapsed = !sidebarCollapsed;
    sidebar.classList.toggle('collapsed');
    
    // Ajustar el margen del contenido principal
    const mainContent = document.querySelector('.main-content');
    if (mainContent) {
        mainContent.style.marginLeft = sidebarCollapsed ? '80px' : '280px';
    }
    
    // Guardar preferencia en localStorage
    localStorage.setItem('sidebarCollapsed', sidebarCollapsed);
}

// Toggle del menú móvil
function toggleMobileMenu() {
    const sidebar = document.querySelector('.sidebar');
    mobileMenuOpen = !mobileMenuOpen;
    sidebar.classList.toggle('show');
}

// Cerrar menú móvil al hacer clic fuera
document.addEventListener('click', function(e) {
    const sidebar = document.querySelector('.sidebar');
    const mobileBtn = document.querySelector('.mobile-menu-btn');
    
    if (mobileMenuOpen && !sidebar.contains(e.target) && e.target !== mobileBtn) {
        toggleMobileMenu();
    }
});

// Inicialización del menú al cargar la página
document.addEventListener('DOMContentLoaded', function() {
    // Cargar preferencia del menú
    if (localStorage.getItem('sidebarCollapsed') === 'true') {
        toggleSidebar();
    }
    
    // Manejar redimensionamiento de la ventana
    window.addEventListener('resize', function() {
        if (window.innerWidth > 992 && mobileMenuOpen) {
            toggleMobileMenu();
        }
    });
});